@extends('backoffice.dashboard')
@section('content')
<link rel="stylesheet" href="{{ asset('BackOfficeAR/css/formulaire.css') }}">


@if(Auth::check())

<div class="container">
    <style>
        .numero-cadre {
            display: inline-block;
            width: 25px;
            height: 25px;
            line-height: 25px;
            margin-right: 5px;
            text-align: center;
            border-radius: 5px;
            font-family: Arial, sans-serif;
            font-weight: bold;
            font-size: 12px;
            color: #ffffff;
            background-color: #d82b2a;
            vertical-align: middle;
        }
    </style>
    
    <form action="" method="POST" enctype="multipart/form-data" lang="ar">    
        <h3 class="mb-4 text-center"> تعديل معلومات مركب أو مركز إقامة </h3>
        <h4 class="mt-3">المعطيات</h4>

        <div class="row mt-3 text-end">
            <label class="col-sm-2 col-form-label"> الإسم بالعربية<span class="text-danger">*</span></label>
            <div class="col-sm-4">
                <input name="nom_ar" type="text" class="form-control" required 
                    value="{{ old('nom_ar', $auberge->nom_ar) }}">
            </div>

            <label class="col-sm-2 col-form-label"> الإسم بالفرنسية<span class="text-danger">*</span></label>
            <div class="col-sm-4">
                <input name="nom_fr" type="text" class="form-control" required 
                    value="{{ old('nom_fr', $auberge->nom_fr) }}">
            </div>
        </div>

        <div class="row mt-3 text-end">
            <label class="col-sm-2 col-form-label"> الإسم بالإنقليزية<span class="text-danger">*</span></label>
            <div class="col-sm-4">
                <input name="nom_en" type="text" class="form-control" required 
                    value="{{ old('nom_en', $auberge->nom_en) }}">
            </div>

            <label class="col-sm-2 col-form-label"> الصبغة </label>
            <div class="col-sm-4">
                <select name="epa" class="form-control" required>
                    <option value="">-- اختر الصبغة --</option>
                    <option value="EPA" {{ old('epa', $auberge->epa) == 'EPA' ? 'selected' : '' }}>EPA</option>
                    <option value="Non EPA" {{ old('epa', $auberge->epa) == 'Non EPA' ? 'selected' : '' }}>Non EPA</option>
                </select>
            </div>
        </div>

        <div class="form-group mt-3">
            <label for="description_ar" class="col-sm-6 col-form-label"> تعريف المركز بالعربية<span class="text-danger">*</span> </label>
            <textarea name="description_ar" placeholder="" id="description_ar" class="form-control" rows="4" required> {{ old('description_ar', $auberge->description_ar ?? '') }}</textarea>
        </div>

        <div class="form-group mt-3">
            <label for="description_fr" class="col-sm-6 col-form-label"> تعريف المركز بالفرنسية<span class="text-danger">*</span> </label>
            <textarea name="description_fr" placeholder="" id="description_fr" class="form-control" rows="4" required> {{ old('description_fr', $auberge->description_fr ?? '') }}</textarea>
        </div>

        <div class="form-group mt-3">
            <label for="description_en" class="col-sm-6 col-form-label"> تعريف المركز بالإنقليزية<span class="text-danger">*</span> </label>
            <textarea name="description_en" placeholder="" id="description_en" class="form-control" rows="4" required> {{ old('description_en', $auberge->description_en ?? '') }}</textarea>
        </div>

        <div class="row mt-3 text-end">
            <label class="col-sm-2 col-form-label">خط العرض (Latitude)<span class="text-danger">*</span></label>
            <div class="col-sm-4">
                <input type="text" name="latitude" class="form-control"
                    value="{{ old('latitude', $auberge->latitude ?? '') }}"
                    placeholder="مثلاً: 36.8065">
            </div>

            <label class="col-sm-2 col-form-label">خط الطول (Longitude)<span class="text-danger">*</span></label>
            <div class="col-sm-4">
                <input type="text" name="longitude" class="form-control"
                    value="{{ old('longitude', $auberge->longitude ?? '') }}"
                    placeholder="مثلاً: 10.1815">
            </div>
        </div>


        <div class="row mt-3 text-end">
            <label class="col-sm-2 col-form-label"> الوسط الذي توجد به المؤسسة </label>
            <div class="col-sm-4">
                <select name="id_milieu_auberge" class="form-control" required>
                    <option value="">-- اختر الوسط --</option>
                    @foreach($milieux as $milieu)
                        <option value="{{ $milieu->id_type }}" {{ old('id_milieu_auberge', $auberge->id_milieu_auberge) == $milieu->id_type ? 'selected' : '' }}>
                            {{ $milieu->type_ar }}
                        </option>
                    @endforeach
                </select>
            </div>

            <label class="col-sm-2 col-form-label"> الإحداثيات </label>
            <div class="col-sm-4">
                <input type="text" name="coordonnees" class="form-control" 
                    value="{{ old('coordonnees', $auberge->coordonnees) }}">
            </div>
        </div>

        <div class="row mt-3 text-end">
            <label class="col-sm-2 col-form-label"> العنوان <span class="text-danger">*</span> </label>
            <div class="col-sm-4">
                <input type="text" name="adresse" class="form-control" 
                    value="{{ old('adresse', $auberge->adresse) }}">
            </div>

            <label class="col-sm-2 col-form-label"> الترقيم البريدي <span class="text-danger">*</span></label>
            <div class="col-sm-4">
                <input type="text" name="code_postal" class="form-control" 
                   value="{{ old('code_postal', $auberge->code_postal) }}">
            </div>
        </div>

        <div class="row mt-3 text-end">
            <label class="col-sm-2 col-form-label"> الولاية <span class="text-danger">*</span></label>
            <div class="col-sm-4">
                <select required class="form-control" id="gouvernorat_id" name="gouvernorat_id">
                    <option value="" disabled>اختر...</option>
                        @foreach($gouvernorats as $gouv)
                            <option value="{{ $gouv->id_gouver }}" {{ old('gouvernorat_id', $auberge->gouver_id) == $gouv->id_gouver ? 'selected' : '' }}>
                                {{ $gouv->nom_ar }}
                            </option>
                        @endforeach
                </select>
            </div>
            
            
            <label class="col-sm-2 col-form-label"> المعتمدية <span class="text-danger">*</span></label>
            <div class="col-sm-4">
                    <select required class="form-control" id="delegation_id" name="delegation_id" {{ $auberge->delegation_id ? '' : 'disabled' }}>
                        <option value="" disabled {{ old('delegation_id', $auberge->delegation_id ?? '') ? '' : 'selected' }}>اختر...</option>
                        @if($auberge->delegation_id)
                            @foreach($delegations as $del)
                                <option value="{{ $del->id_delegation }}"
                                    {{ old('delegation_id', $auberge->delegation_id ?? '') == $del->id_delegation ? 'selected' : '' }}>
                                    {{ $del->nom_ar }}
                                </option>
                            @endforeach
                        @endif
                    </select>
                </div>
        </div>

        {{-- Les autres champs sont similaires au create.blade mais avec old() ou $auberge->value --}}
        <div class="row mt-3 text-end">
            <label class="col-sm-2 col-form-label"> الهاتف القار <span class="text-danger">*</span></label>
            <div class="col-sm-4">
                <input type="text" name="contact_tel" class="form-control" 
                    value="{{ old('contact_tel', $auberge->contact_tel) }}">
            </div>

            <label class="col-sm-2 col-form-label"> الفاكس <span class="text-danger">*</span></label>
            <div class="col-sm-4">
                <input type="text" name="fax" class="form-control" 
                   value="{{ old('fax', $auberge->fax) }}">
            </div>
        </div>

        <div class="row mt-3 text-end align-items-start">
            <label class="col-sm-2 col-form-label">
                البريد الإلكتروني للمؤسسة <span class="text-danger">*</span>
            </label>
            <div class="col-sm-4">
                <input type="email" 
                    name="contact_email" 
                    class="form-control" 
                    value="{{ old('contact_email', $auberge->contact_email ?? '') }}">
            </div>

            <label for="image" class="col-sm-2 col-form-label">
                صورة المركب <span class="text-danger">*</span>
            </label>
            <div class="col-sm-4">
                <input type="file" name="image" id="image" class="form-control" accept="image/*">

                @if(!empty($auberge->image))
                    <div class="mt-2 text-center">
                        <img  src="{{ asset('storage/'.$auberge->image) }}"
                            alt="الصورة الحالية"
                            style="max-width: 200px; max-height: 150px; border-radius: 8px; object-fit: cover; box-shadow: 0 2px 5px rgba(0,0,0,0.1);">
                    </div>
                @endif
            </div>
        </div>


        <div class="row mt-3 text-end">
            <label class="col-sm-2 col-form-label">سعر الليلة (سرير) <span class="text-danger">*</span></label>
            <div class="col-sm-4">
                <input type="number" name="prix_lit" class="form-control" 
                    value="{{ old('prix_lit', $auberge->prix_lit ?? '') }}" step="0.01" min="0">
            </div>
        </div>
        

        <div class="form-group mt-3">
            
        </div>

        <h4 class="mt-3"> مدير المؤسسة </h4>

        <div class="row mt-3 text-end">
            <label class="col-sm-2 col-form-label">  الإسم واللقب <span class="text-danger">*</span></label>
            <div class="col-sm-4">
                <input type="text" name="nom_directeur" class="form-control"
                    value="{{ old('nom_directeur', $auberge->nom_directeur) }}">
            </div>

            <label class="col-sm-2 col-form-label"> الهاتف الجوال <span class="text-danger">*</span></label>
            <div class="col-sm-4">
                <input type="text" name="tel_directeur" class="form-control"
                    value="{{ old('tel_directeur', $auberge->tel_directeur) }}">
            </div>
        </div>

        <h4 class="mt-3"> الخدمات</h4>
        <div class="row mt-3 text-end">
            <label class="col-sm-2 col-form-label"> هل يوجد فضاء للمشروبات ؟ </label>
            <div class="col-sm-4">
                <select name="espace_boisson" id="espace_boisson" class="form-control" required>
                    <option value="" disabled {{ old('espace_boisson', $auberge->espace_boisson) === null ? 'selected' : '' }}>اختر...</option>
                    <option value="1" {{ old('espace_boisson', $auberge->espace_boisson) == 1 ? 'selected' : '' }}>نعم</option>
                    <option value="0" {{ old('espace_boisson', $auberge->espace_boisson) == 0 ? 'selected' : '' }}>لا</option>
                </select>
            </div>
            
            <label class="col-sm-2 col-form-label"> مسبح  <span class="text-danger">*</span></label>
            <div class="col-sm-4">
                <select name="piscine" class="form-control" required>
                    <option value="" disabled {{ old('piscine', $auberge->piscine) === null ? 'selected' : '' }}>اختر...</option>
                    <option value="1" {{ old('piscine', $auberge->piscine) == 1 ? 'selected' : '' }}>نعم</option>
                    <option value="0" {{ old('piscine', $auberge->piscine) == 0 ? 'selected' : '' }}>لا</option>
                </select>
            </div>
        </div>

        <div class="form-group row mt-4">
    <h5 class="text-center mb-3">الفضاءات المتوفرة</h5>

    <table id="espaces-table" class="table table-bordered">
        <thead>
            <tr>
                <th>#</th>
                <th>الإسم بالعربية</th>
                <th>الإسم بالفرنسية</th>
                <th>الإسم بالانقليزية</th>
                <th>إجراء</th>
            </tr>
        </thead>
        <tbody id="espaces-body">
            @php
                // On prend soit les anciennes valeurs après validation, soit les espaces existants
                $oldEspaces = old('espaces', $auberge->espaces->toArray());
                $espaceIndex = 0;
            @endphp

            @foreach($oldEspaces as $espace)
            <tr>
                <td class="row-number">{{ $loop->iteration }}</td>
                <td>
                    <input type="hidden" name="espaces[{{ $espaceIndex }}][id_espace]" value="{{ $espace['id_espace'] ?? '' }}">
                    <input type="text" name="espaces[{{ $espaceIndex }}][nom_ar]" class="form-control" value="{{ $espace['nom_ar'] ?? '' }}" required>
                </td>
                <td>
                    <input type="text" name="espaces[{{ $espaceIndex }}][nom_fr]" class="form-control" value="{{ $espace['nom_fr'] ?? '' }}" required>
                </td>
                <td>
                    <input type="text" name="espaces[{{ $espaceIndex }}][nom_en]" class="form-control" value="{{ $espace['nom_en'] ?? '' }}" required>
                </td>
                <td>
                    <button type="button" class="btn btn-danger btn-sm" onclick="removeEspaceRow(this)">حذف</button>
                </td>
            </tr>
            @php $espaceIndex++; @endphp
            @endforeach
        </tbody>
    </table>

    <button type="button" class="btn btn-success mt-2" onclick="addEspaceRow()">إضافة فضاء جديد</button>
</div>





        


        <div class="form-group row mt-4">
    <h5 class="text-center mb-3">الغرف</h5>

    <table id="chambres-table" class="custom-table">
        <thead>
            <tr>
                <th>#</th>
                <th>نوع الغرفة</th>
                <th>الطاقة الاستيعابية</th>
                <th>رقم الغرفة</th>
                <th>إجراء</th>
            </tr>
        </thead>

        <tbody id="chambres-body">
            @php
                $oldChambres = old('chambres', isset($auberge) ? $auberge->chambres->toArray() : []);
            @endphp

            @foreach($oldChambres as $index => $c)
            <tr>
                <td class="row-number">{{ $index + 1 }}</td>

                <td>
                    <select name="chambres[{{ $index }}][type_chambre_id]" class="form-control type-chambre" required>
                        <option value="">-- اختر --</option>
                        @foreach($typesChambres as $t)
                            <option value="{{ $t->id_type }}" 
                                {{ ($c['type_chambre_id'] ?? '') == $t->id_type ? 'selected' : '' }}>
                                {{ $t->type_ar }}
                            </option>
                        @endforeach
                    </select>
                    <input type="hidden" name="chambres[{{ $index }}][id_chambre_tente]" value="{{ $c['id_chambre_tente'] ?? '' }}">
                </td>

                <td><input type="number" name="chambres[{{ $index }}][capacite]" class="form-control nb-lits" value="{{ $c['capacite'] ?? '' }}" required></td>

                <td><input type="text" name="chambres[{{ $index }}][num_chambre]" class="form-control" value="{{ $c['num_chambre'] ?? '' }}" required></td>

                <td>
                    <button type="button" class="btn btn-danger btn-sm" onclick="removeChambreRow(this)">حذف</button>
                </td>
            </tr>
            @endforeach
        </tbody>
    </table>

    <button type="button" class="btn btn-success mt-2" onclick="addChambreRow()">إضافة غرفة</button>
</div>

{{-- Totaux et statistiques --}}
<div class="row mt-3 text-end">
    <label class="col-sm-2 col-form-label">طاقة الإستيعاب تحت المباني <span class="text-danger">*</span></label>
    <div class="col-sm-4">
        <input type="number" name="capacite_batiment" id="capacite_batiment" class="form-control" 
            value="{{ old('capacite_batiment', $auberge->capacite_batiment ?? 0) }}" readonly>
    </div>

    <label class="col-sm-2 col-form-label">عدد الغرف <span class="text-danger">*</span></label>
    <div class="col-sm-4">
        <input type="number" name="nb_chambres" id="nb_chambres" class="form-control" 
            value="{{ old('nb_chambres', $auberge->nb_chambres ?? 0) }}" readonly>
    </div>
</div>

<div class="row mt-3 text-end">
    <label class="col-sm-2 col-form-label">عدد الغرف الفردية</label>
    <div class="col-sm-4">
        <input type="number" name="nb_chambres_single" id="nb_chambres_single" class="form-control" 
            value="{{ old('nb_chambres_single', $auberge->nb_chambres_single ?? 0) }}" readonly>
    </div>

    <label class="col-sm-2 col-form-label">عدد الغرف ثنائي</label>
    <div class="col-sm-4">
        <input type="number" name="nb_chambres_double" id="nb_chambres_double" class="form-control" 
            value="{{ old('nb_chambres_double', $auberge->nb_chambres_double ?? 0) }}" readonly>
    </div>
</div>

<div class="row mt-3 text-end">
    <label class="col-sm-2 col-form-label">عدد الغرف ثلاثي</label>
    <div class="col-sm-4">
        <input type="number" name="nb_chambres_triple" id="nb_chambres_triple" class="form-control" 
            value="{{ old('nb_chambres_triple', $auberge->nb_chambres_triple ?? 0) }}" readonly>
    </div>

    <label class="col-sm-2 col-form-label">عدد الغرف رباعي</label>
    <div class="col-sm-4">
        <input type="number" name="nb_chambres_quadra" id="nb_chambres_quadra" class="form-control" 
            value="{{ old('nb_chambres_quadra', $auberge->nb_chambres_quadra ?? 0) }}" readonly>
    </div>
</div>

<div class="row mt-3 text-end">
    <label class="col-sm-2 col-form-label">عدد الغرف أكثر من رباعي</label>
    <div class="col-sm-4">
        <input type="number" name="nb_chambres_plus" id="nb_chambres_plus" class="form-control" 
            value="{{ old('nb_chambres_plus', $auberge->nb_chambres_plus ?? 0) }}" readonly>
    </div>

    <label class="col-sm-2 col-form-label">عدد الوحدات الصحية داخل الغرف</label>
    <div class="col-sm-4">
        <input type="number" name="nb_salles_de_bain" id="nb_salles_de_bain" class="form-control" 
            value="{{ old('nb_salles_de_bain', $auberge->nb_salles_de_bain ?? 0) }}">
    </div>
</div>

        <div class="row mt-3 text-end">
            <label class="col-sm-2 col-form-label">
            عدد الوحدات الصحية المشتركة</label>
            <div class="col-sm-4">
                <input type="number" name="nb_salles_de_bain_comm" class="form-control" 
                    value="{{ old('nb_salles_de_bain_comm', $auberge->nb_salles_de_bain_comm) }}">
            </div>
            <label class="col-sm-2 col-form-label">
            عدد الغرف التي تحتوي على تلفاز</label>
            <div class="col-sm-4">
                <input type="number" name="nb_chambres_tv" class="form-control" 
                    value="{{ old('nb_chambres_tv', $auberge->nb_chambres_tv) }}">
            </div>
        </div>

        <div class="row mt-3 text-end">
            <label class="col-sm-2 col-form-label">
            عدد الغرف المكيفة</label>
            <div class="col-sm-4">
                <input type="number" name="nb_chambres_clim" class="form-control" 
                    value="{{ old('nb_chambres_clim', $auberge->nb_chambres_clim) }}">
            </div>
            <label class="col-sm-2 col-form-label">
            عدد الغرف التي تحتوي على ثلاجة</label>
            <div class="col-sm-4">
                <input type="number" name="nb_chambres_frigo" class="form-control" 
                    value="{{ old('nb_chambres_frigo', $auberge->nb_chambres_frigo) }}">
            </div>
        </div>

        <div class="row mt-3 text-end">
            <label class="col-sm-2 col-form-label">
            طاقة الإستيعاب تحت الخيام إن وجدت</label>
            <div class="col-sm-4">
                <input type="number" name="capacite_tentes" class="form-control" 
                    value="{{ old('capacite_tentes', $auberge->capacite_tentes) }}">
            </div>
            <label for="cuisine_fonctionnelle" class="col-sm-2 col-form-label">المطبخ وظيفي</label>
            <div class="col-sm-4">
                <select name="cuisine_fonctionnelle" id="cuisine_fonctionnelle" class="form-control">
                    <option value="" disabled>اختر...</option>
                    <option value="1" {{ old('cuisine_fonctionnelle', $auberge->cuisine_fonctionnelle) == '1' ? 'selected' : '' }}>نعم</option>
                    <option value="0" {{ old('cuisine_fonctionnelle', $auberge->cuisine_fonctionnelle) == '0' ? 'selected' : '' }}>لا</option>
                </select>
            </div>
        </div>


       

                <div class="form-group row mt-4">
    <h5 class="text-center mb-3">الملاعب الرياضية</h5>

    <table id="terrains-table" class="table table-bordered">
        <thead>
            <tr>
                <th>#</th>
                <th>الإسم بالعربية</th>
                <th>الإسم بالفرنسية</th>
                <th>الإسم بالانقليزية</th>
                <th>إجراء</th>
            </tr>
        </thead>
        <tbody id="terrains-body">
            @php
                $oldterrains = old('terrains', $auberge->terrains->toArray());
                $terrainsIndex = 0;
            @endphp

            @foreach($oldterrains as $terrain)
            <tr>
                <td class="row-number">{{ $loop->iteration }}</td>
                <td>
                    <input type="hidden" name="terrains[{{ $terrainsIndex }}][id_terrain]" value="{{ $terrain['id_terrain'] ?? '' }}">
                    <input type="text" name="terrains[{{ $terrainsIndex }}][nom_ar]" class="form-control" value="{{ $terrain['nom_ar'] ?? '' }}" required>
                </td>
                <td>
                    <input type="text" name="terrains[{{ $terrainsIndex }}][nom_fr]" class="form-control" value="{{ $terrain['nom_fr'] ?? '' }}" required>
                </td>
                <td>
                    <input type="text" name="terrains[{{ $terrainsIndex }}][nom_en]" class="form-control" value="{{ $terrain['nom_en'] ?? '' }}" required>
                </td>
                <td>
                    <button type="button" class="btn btn-danger btn-sm" onclick="removeterrainsRow(this)">حذف</button>
                </td>
            </tr>
            @php $terrainsIndex++; @endphp
            @endforeach
        </tbody>
    </table>

    <button type="button" class="btn btn-success mt-2" onclick="addterrainsRow()">إضافة فضاء جديد</button>
</div>

        <div class="form-group row mt-4">
    <h5 class="text-center mb-3">الخدمات المقدمة من طرف المؤسسة</h5>

    <table id="services_auberge-table" class="table table-bordered">
        <thead>
            <tr>
                <th>#</th>
                <th>الإسم بالعربية</th>
                <th>الإسم بالفرنسية</th>
                <th>الإسم بالانقليزية</th>
                <th>إجراء</th>
            </tr>
        </thead>
        <tbody id="services_auberge-body">
            @php
                $oldservices_auberge = old('services_auberge', $auberge->services_auberge->toArray());
                $services_aubergeIndex = 0;
            @endphp

            @foreach($oldservices_auberge as $services_auberge)
            <tr>
                <td class="row-number">{{ $loop->iteration }}</td>
                <td>
                    <input type="hidden" name="services_auberge[{{ $services_aubergeIndex }}][id_service]" value="{{ $services_auberge['id_service'] ?? '' }}">
                    <input type="text" name="services_auberge[{{ $services_aubergeIndex }}][nom_ar]" class="form-control" value="{{ $services_auberge['nom_ar'] ?? '' }}" required>
                </td>
                <td>
                    <input type="text" name="services_auberge[{{ $services_aubergeIndex }}][nom_fr]" class="form-control" value="{{ $services_auberge['nom_fr'] ?? '' }}" required>
                </td>
                <td>
                    <input type="text" name="services_auberge[{{ $services_aubergeIndex }}][nom_en]" class="form-control" value="{{ $services_auberge['nom_en'] ?? '' }}" required>
                </td>
                <td>
                    <button type="button" class="btn btn-danger btn-sm" onclick="removeservices_aubergeRow(this)">حذف</button>
                </td>
            </tr>
            @php $services_aubergeIndex++; @endphp
            @endforeach
        </tbody>
    </table>

    <button type="button" class="btn btn-success mt-2" onclick="addservices_aubergeRow()">إضافة فضاء جديد</button>
</div>
    <div class="form-group row mt-4">
        <h5 class="text-center mb-3">🍽️ قسم خدمات المطعم</h5>
        <table id="restauration-table" class="custom-table">
            <thead>
                <tr>
                    <th>#</th>
                    <th>الإسم بالعربية</th>
                    <th>الإسم بالفرنسية</th>
                    <th>الإسم بالإنجليزية</th>
                    <th>الوصف بالعربية</th>
                    <th>الوصف بالفرنسية</th>
                    <th>الوصف بالإنجليزية</th>
                    <th>التعريفة (د.ت)</th>
                    <th>إجراء</th> 
                </tr>
            </thead>
            <tbody id="restauration-body">
                @foreach($auberge->restaurations as $i => $res)
                    <tr>
                        <td class="row-number"></td>
                        <td>
                            <input type="hidden" name="restaurations[{{ $i }}][id_rest]" value="{{ $res->id_rest }}">
                            <input type="text" name="restaurations[{{ $i }}][nom_ar]" value="{{ $res->nom_ar }}" class="form-control"></td>
                        <td><input type="text" name="restaurations[{{ $i }}][nom_fr]" value="{{ $res->nom_fr }}" class="form-control"></td>
                        <td><input type="text" name="restaurations[{{ $i }}][nom_en]" value="{{ $res->nom_en }}" class="form-control"></td>
                        <td><textarea name="restaurations[{{ $i }}][description_ar]" class="form-control">{{ $res->description_ar }}</textarea></td>
                        <td><textarea name="restaurations[{{ $i }}][description_fr]" class="form-control">{{ $res->description_fr }}</textarea></td>
                        <td><textarea name="restaurations[{{ $i }}][description_en]" class="form-control">{{ $res->description_en }}</textarea></td>
                        <td><input type="number" step="0.01" name="restaurations[{{ $i }}][tarif]" value="{{ $res->tarif }}" class="form-control"></td>
                        <td>
                            <button type="button" class="btn btn-danger btn-sm" onclick="removeRestaurationRow(this)">حذف</button>
                        </td>
                    </tr>
                @endforeach
            </tbody>

        </table>
        <button type="button" class="btn btn-success mt-2" onclick="addRestaurationRow()">إضافة خدمة جديدة</button>
    </div>

        <div class="form-group mt-3">
            <label for="lieux_culturels" class="col-sm-6 col-form-label">المعالم الأثرية والمتاحف والفضاءات الثقافية المجاورة للمؤسسة</label>
            <textarea name="lieux_culturels" id="lieux_culturels" class="form-control" rows="4">{{ old('lieux_culturels', $auberge->lieux_culturels) }}</textarea>
        </div>

        <div class="form-group mt-3">
            <label for="autres_services" class="col-sm-6 col-form-label"> خدمات أخرى </label>
            <textarea name="autres_services" placeholder="أذكر الخدمات الإضافية إن وجدت..." id="autres_services" class="form-control" rows="4">{{ old('autres_services', $auberge->autres_services) }}</textarea>
        </div>

        <div class="text-center mt-4">
            <button type="submit" class="btn btn-success mx-2">
                <i class="la la-save"></i> حفظ التعديلات
            </button>

            <a href="{{ route('auberges.index') }}" class="btn btn-secondary mx-2">
                <i class="la la-arrow-right"></i> رجوع
            </a>
        </div>

    </form>
</div>


@endsection

@else
    <script>
        window.location.href = "{{ route('login') }}";
    </script>
@endif
